<?php
require_once 'config.php';

$user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
if ($user_id <= 0) {
    http_response_code(400);
    die("Invalid user.");
}

$stmt = $pdo->prepare("SELECT id, name FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$user) {
    http_response_code(404);
    die("User not found.");
}

// Log scan
$stmt = $pdo->prepare("INSERT INTO qr_scans (user_id, ip_address, user_agent, track_id) VALUES (?, ?, ?, ?)");
$scan_id = substr(md5(uniqid(rand(), true)), 0, 16); // PHP 5.6+ safe (no random_bytes)
$stmt->execute([$user_id, $_SERVER['REMOTE_ADDR'] ?? '', $_SERVER['HTTP_USER_AGENT'] ?? '', $scan_id]);

echo "Hi " . htmlspecialchars($user['name']) . ", your scan (#$scan_id) recorded.<br>";

// Full working QR image
echo '<img src="https://test.nikosmoney.com/qr.php?user_id=' . $user_id . '&scan_id=' . $scan_id . '&size=8" alt="New QR" style="width:300px;height:300px;">';
?>