<?php
require_once 'config.php';

$qr_url = $user_name = '';
$error = $success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    if (empty($name)) {
        $error = 'Enter a name.';
    } else {
        // Find matching user
        $stmt = $pdo->prepare("SELECT id, name FROM users WHERE name LIKE ? ORDER BY id LIMIT 1");
        $stmt->execute(["%$name%"]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            $user_name = $user['name'];
            $scan_id = substr(md5(uniqid()), 0, 16);
            $qr_url = "https://test.nikosmoney.com/qr.php?user_id={$user['id']}&scan_id=$scan_id";
            $success = "Found: $user_name (ID: {$user['id']}). QR ready!";
        } else {
            $error = "No user found matching '$name'. Check admin panel.";
        }
    }
}

// Dropdown users for easy select
$users = $pdo->query("SELECT id, name FROM users ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Find User & Get QR</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; max-width: 500px; margin: 50px auto; background: linear-gradient(135deg, #667eea, #764ba2); min-height: 100vh; display: flex; align-items: center; }
        .container { background: white; padding: 40px; border-radius: 16px; box-shadow: 0 20px 40px rgba(0,0,0,0.1); width: 100%; }
        h1 { text-align: center; color: #333; margin-bottom: 30px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; color: #555; font-weight: 500; }
        input, select { width: 100%; padding: 14px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box; transition: border-color 0.3s; }
        input:focus, select:focus { border-color: #667eea; outline: none; }
        button { width: 100%; padding: 14px; background: linear-gradient(135deg, #28a745, #20c997); color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; }
        button:hover { transform: translateY(-2px); transition: 0.2s; }
        .error { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #f5c6cb; }
        .success { background: #d4edda; color: #155724; padding: 20px; border-radius: 12px; margin-bottom: 20px; border: 1px solid #c3e6cb; text-align: center; }
        .qr-section { text-align: center; margin-top: 30px; }
        .qr-section img { width: 300px; height: 300px; border: 3px solid #28a745; border-radius: 12px; box-shadow: 0 10px 30px rgba(40,167,69,0.3); cursor: pointer; }
        .qr-section img:hover { transform: scale(1.05); }
        .qr-url { background: #f8f9fa; padding: 12px; border-radius: 8px; margin-top: 15px; font-family: monospace; word-break: break-all; font-size: 12px; }
        .users-list { background: #e9ecef; padding: 15px; border-radius: 8px; margin-bottom: 20px; max-height: 200px; overflow-y: auto; }
        .user-item { padding: 8px; border-bottom: 1px solid #dee2e6; cursor: pointer; }
        .user-item:hover { background: #dee2e6; }
        a.admin { display: block; margin-top: 30px; text-align: center; color: #007bff; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Find Name → Get QR</h1>
        
        <div class="users-list">
            <strong>Existing Users:</strong>
            <?php foreach ($users as $u): ?>
                <div class="user-item" onclick="document.getElementById('name').value='<?= htmlspecialchars($u['name']) ?>';"><?= $u['name'] ?> (ID: <?= $u['id'] ?>)</div>
            <?php endforeach; ?>
            <?php if (empty($users)): ?><p>No users yet (check admin).</p><?php endif; ?>
        </div>
        
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success"><?= htmlspecialchars($success) ?></div>
            <div class="qr-section">
                <img src="<?= $qr_url ?>" alt="QR Code" onclick="window.open(this.src, '_blank')">
                <div class="qr-url"><?= htmlspecialchars($qr_url) ?></div>
                <p><small>✅ Scan logs to admin panel. Print/share!</small></p>
            </div>
        <?php else: ?>
            <form method="POST">
                <div class="form-group">
                    <label for="name">Search Name (partial OK)</label>
                    <input type="text" id="name" name="name" required list="userlist" autocomplete="off" placeholder="e.g., John">
                    <datalist id="userlist">
                        <?php foreach ($users as $u): ?>
                            <option value="<?= htmlspecialchars($u['name']) ?>">
                        <?php endforeach; ?>
                    </datalist>
                </div>
                <button type="submit">Generate QR</button>
            </form>
        <?php endif; ?>
        
        <a href="admin.php" class="admin">🔐 Admin Login</a>
    </div>
</body>
</html>