<?php
require_once 'config.php'; // $pdo

$name = $email = "";
$errors = [];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $name  = trim($_POST["name"] ?? "");
    $email = trim($_POST["email"] ?? "");

    if ($name === "") {
        $errors[] = "Name is required.";
    }
    if ($email === "") {
        $errors[] = "Email is required.";
    }

    if (empty($errors)) {
        $stmt = $pdo->prepare("INSERT INTO users (name, email) VALUES (:name, :email)");
        $ok = $stmt->execute([
            ":name"  => $name,
            ":email" => $email
        ]);

        if ($ok) {
            // redirect back to admin list
            header("Location: admin.php");
            exit;
        } else {
            $errors[] = "Failed to create user.";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Create User</title>
    <style>
        body { font-family: Arial; max-width: 500px; margin: 20px auto; }
        .error { color: red; margin-bottom: 10px; }
        label { display:block; margin-top:10px; }
    </style>
</head>
<body>
    <h1>Create User</h1>
    <?php if (!empty($errors)): ?>
        <div class="error">
            <?php foreach ($errors as $e) echo htmlspecialchars($e) . "<br>"; ?>
        </div>
    <?php endif; ?>

    <form method="post" action="create_user.php">
        <label>
            Name:
            <input type="text" name="name" value="<?= htmlspecialchars($name) ?>">
        </label>
        <label>
            Email:
            <input type="email" name="email" value="<?= htmlspecialchars($email) ?>">
        </label>

        <button type="submit">Save</button>
        <a href="admin.php">Cancel</a>
    </form>
</body>
</html>