<?php
// admin.php - Dynamic QR Tracking
session_start();
require_once 'config.php';

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$baseScanUrl = 'https://test.nikosmoney.com/scan.php?user_id=';

// FETCH DATA
$userStmt = $pdo->query("SELECT id, name, email, created_at FROM users ORDER BY id DESC");
$users = $userStmt->fetchAll(PDO::FETCH_ASSOC);

$scanStmt = $pdo->query("
    SELECT qr_scans.id AS scan_id, qr_scans.scan_time, qr_scans.ip_address, 
           qr_scans.track_id, users.id AS user_id, users.name AS user_name
    FROM qr_scans JOIN users ON qr_scans.user_id = users.id 
    ORDER BY qr_scans.scan_time DESC LIMIT 50
");
$scans = $scanStmt->fetchAll(PDO::FETCH_ASSOC);

$countStmt = $pdo->query("SELECT COUNT(*) as total FROM qr_scans");
$totalScans = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Tracking Admin</title>
    <style>
        /* Same styles as previous - modern tables, responsive, etc. */
        body { font-family: 'Segoe UI', sans-serif; max-width: 1400px; margin: 20px auto; background: #f8f9fa; }
        header { background: linear-gradient(135deg, #007bff, #0056b3); color: white; padding: 20px; border-radius: 12px; text-align: center; }
        h1 { margin: 0; font-size: 32px; }
        .stats { font-size: 18px; margin-top: 10px; }
        .scan-count { color: #28a745; font-weight: bold; }
        a.button { display: inline-block; padding: 12px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 6px; margin: 10px 5px 0 0; }
        a.button:hover { background: #218838; }
        a.logout { background: #dc3545; float: right; margin-top: -50px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; background: white; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        th, td { padding: 12px 15px; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; font-weight: 600; }
        tr:hover { background: #f8f9ff; }
        .qr-cell { max-width: 220px; }
        .qr-cell code { display: block; font-size: 12px; background: #f1f3f4; padding: 6px; border-radius: 4px; margin-bottom: 8px; word-break: break-all; }
        .qr-cell img { width: 150px; height: 150px; border: 2px solid #eee; border-radius: 8px; cursor: pointer; }
        .qr-cell img:hover { transform: scale(1.05); transition: 0.2s; }
        .small { font-size: 13px; color: #666; }
        .track-id { background: #e7f3ff; padding: 4px 8px; border-radius: 4px; font-family: monospace; font-size: 11px; }
        @media (max-width: 768px) { .qr-cell img { width: 120px; height: 120px; } }
    </style>
</head>
<body>
    <header>
        <h1>🔍 QR Tracking Dashboard</h1>
        <p class="stats">Total Scans: <span class="scan-count"><?= number_format($totalScans) ?></span> | <?= date('Y-m-d H:i:s') ?></p>
        <a href="create_user.php" class="button">+ New User</a>
        <a href="login.php?logout=1" class="button logout" onclick="return confirm('Logout?')">🚪 Logout</a>
    </header>

    <h2>👥 Users (<?= count($users) ?>)</h2>
    <table>
        <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Created</th><th>📱 Fresh QR (Click to Enlarge)</th></tr></thead>
        <tbody>
            <?php if (empty($users)): ?>
                <tr><td colspan="5" style="text-align:center;padding:40px;color:#999;">No users. Create one!</td></tr>
            <?php else: foreach ($users as $u): ?>
                <?php $qrImg = 'qr.php?user_id=' . $u['id'] . '&scan_id=' . time(); ?>
                <tr>
                    <td><strong><?= $u['id'] ?></strong></td>
                    <td><?= htmlspecialchars($u['name']) ?></td>
                    <td><?= htmlspecialchars($u['email']) ?></td>
                    <td class="small"><?= date('M j, Y', strtotime($u['created_at'])) ?></td>
                    <td class="qr-cell">
                        <code><?= htmlspecialchars($baseScanUrl . $u['id']) ?></code>
                        <img src="<?= $qrImg ?>" alt="QR <?= $u['name'] ?>" 
                             onclick="window.open(this.src.replace('150','10'), '_blank')">
                    </td>
                </tr>
            <?php endforeach; endif; ?>
        </tbody>
    </table>

    <h2>📊 Recent Scans (50)</h2>
    <table>
        <thead><tr><th>ID</th><th>User</th><th>Time</th><th>IP</th><th>Track ID</th></tr></thead>
        <tbody>
            <?php if (empty($scans)): ?>
                <tr><td colspan="5" style="text-align:center;padding:40px;color:#999;">Waiting for scans...</td></tr>
            <?php else: foreach ($scans as $s): ?>
                <tr>
                    <td><?= $s['scan_id'] ?></td>
                    <td><?= htmlspecialchars($s['user_name']) ?></td>
                    <td class="small"><?= date('H:i:s M j', strtotime($s['scan_time'])) ?></td>
                    <td><?= htmlspecialchars($s['ip_address']) ?></td>
                    <td><span class="track-id"><?= htmlspecialchars($s['track_id']) ?></span></td>
                </tr>
            <?php endforeach; endif; ?>
        </tbody>
    </table>

    <p style="text-align:center;color:#666;font-size:12px;">
        <a href="?t=<?= time() ?>" style="color:#007bff;">🔄 Refresh</a> | Each QR unique via timestamp/scan_id
    </p>
</body>
</html>